function generateAlphaNumeric() {
    const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    let result = "";
    for (let i = 0; i < 6; i++) {
        const randomIndex = Math.floor(Math.random() * characters.length);
        result += characters[randomIndex];
    }
    return result;
}

function getUrlParameter(name) 
      {
          const urlParams = new URLSearchParams(window.location.search);
          return urlParams.get(name);
      }
      function startTimer() {
            let timerElement = document.getElementById('timer');
            let timeRemaining = 60;

            countdownTimer = setInterval(() => {
                timeRemaining--;
                timerElement.innerText = timeRemaining;

                // When the timer reaches zero, stop it and reset room scores
                if (timeRemaining <= 0) {
                    clearInterval(countdownTimer);
                    socket.send(JSON.stringify({ score: 0 }));  // Send a final score or notify of round end
                    // Reset scores if necessary
                }
            }, 1000);  // Update every second
        }
        
let socket;
        let username;
        let room_id;
        var last_me = 0;
        var last_he = 0;
        
        let isSocketOpen = false;  // Flag to check if socket is open
        
        function joinRoom() {
            username = getUrlParameter("username");
            if (username.length < 3) 
            {
                username = generateAlphaNumeric();
            }
            room_id = getUrlParameter("code");
            socket = new WebSocket(`wss://bigboy.app/KAALA/GAME/ws/${room_id}/${username}`);
        
            socket.onopen = () => {
                startTimer();
                console.log("Connected to the room");
                isSocketOpen = true;  // Set flag to true when socket is open
            };
        
            socket.onmessage = (event) => {
                if(event.data == "WIN")
                {
                    window.location.href="won.html?me="+last_me+"&he="+last_he+"&user="+username;
                }
                else if(event.data == "LOOSE")
                {
                    window.location.href="fail.html?me="+last_me+"&he="+last_he+"&user="+username;
                }
                else
                {
                    var score = JSON.parse(event.data);
                    if (score.hasOwnProperty(username)) 
                    {
                        var score_button = document.getElementById("me");
                        score_button.innerText = score[username];
                        last_me = score[username];
                    }
                    for (var key in score) 
                    {
                        if (score.hasOwnProperty(key) && key !== username) 
                        {
                            var score_button = document.getElementById("he");
                            score_button.innerText = score[key];
                            last_he = score[key];
                        }
                    }
                }
            };
        
            socket.onclose = () => {
                alert('You have been disconnected from the room.');
                isSocketOpen = false;  // Set flag to false when socket is closed
            };
        }
        
        function submitScore(score) {
            if (!isSocketOpen) {
                alert("WebSocket is not open yet. Please wait for the connection.");
                return;
            }
        
            const scoreData = { score: score }; // Create a JSON object with the score key
            socket.send(JSON.stringify(scoreData)); // Send the score as a JSON string
            console.log("Score sent to server");
        }
        
        
      joinRoom();
      function game_over()
      {
          window.location.href="fail.html?me="+last_me+"&he="+last_he+"&user="+username;
      }